﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace cifXTest
{
    public partial class cifXMain : Form
    {
        private cifXUser cifXUser = new cifXUser();

        public cifXMain()
        {
            InitializeComponent();
        }

        private void cifXMain_Load(object sender, EventArgs e)
        {
            AppStart();
            OpenDriver();
            this.Text = "cifX Test Application for C#";
        }

        private void applicationReadyToolStripMenuItem_Click(object sender, EventArgs e)
        {
            cifXAppReady CIFXAPPREADY = new cifXAppReady();
            CIFXAPPREADY.MdiParent = this;
            CIFXAPPREADY.Dock = DockStyle.Fill;
            CIFXAPPREADY.Show();
        }

        private void quitToolStripMenuItem_Click(object sender, EventArgs e)
        {
            UInt32 lret = 0;
            lret = cifXUser.xDriverClose();
            this.Close();
        }

        private void downloadToolStripMenuItem_Click(object sender, EventArgs e)
        {
            cifXDownload CIFXDOWNLOAD = new cifXDownload();
            CIFXDOWNLOAD.MdiParent = this;
            CIFXDOWNLOAD.Dock = DockStyle.Fill;
            CIFXDOWNLOAD.Show();
        }

        private void resetToolStripMenuItem_Click(object sender, EventArgs e)
        {
            cifXReset CIFXRESET = new cifXReset();
            CIFXRESET.MdiParent = this;
            CIFXRESET.Dock = DockStyle.Fill;
            CIFXRESET.Show();
        }

        private void closeToolStripMenuItem_Click(object sender, EventArgs e)
        {
            UInt32 lret = 0;

            if (cifXUser.hChannel != 0)
            {
                //a channel is open and must be closed first
                lret = cifXUser.xChannelClose();
            }
            else if (cifXUser.hSysDevice != 0)
            {
                //a sysdevice is open and must be closed first
                lret = cifXUser.xSysdeviceClose();
            }
        }

        private void menuStrip1_MenuActivate(object sender, EventArgs e)
        {
            foreach (Form fChild in MdiChildren)
                fChild.Close();

            if (cifXUser.hSysDevice > 0 && cifXUser.hChannel == 0)
                SysDeviceOpened();
            else if (cifXUser.hSysDevice > 0 && cifXUser.hChannel > 0)
                ChannelOpened();
            else
                AppStart();
        }

        private void applicationReadyToolStripMenuItem_Click_1(object sender, EventArgs e)
        {
            cifXAppReady APPREADY = new cifXAppReady();
            APPREADY.MdiParent = this;
            APPREADY.Dock = DockStyle.Fill;
            APPREADY.Show();
        }

        private void openToolStripMenuItem_Click(object sender, EventArgs e)
        {
            cifXDeviceOPenDlg CIFXDEVICEOPENDLG = new cifXDeviceOPenDlg();
            CIFXDEVICEOPENDLG.MdiParent = this;
            CIFXDEVICEOPENDLG.Dock = DockStyle.Fill;
            CIFXDEVICEOPENDLG.Show();
        }

        private void driverInformationToolStripMenuItem_Click(object sender, EventArgs e)
        {
            cifXDrvInfo CIFXINFO = new cifXDrvInfo();
            CIFXINFO.MdiParent = this;
            CIFXINFO.Dock = DockStyle.Fill;
            CIFXINFO.Show();
        }

        private void channelInformationToolStripMenuItem_Click(object sender, EventArgs e)
        {
            cifXChannelInfo CIFXCHNINFO = new cifXChannelInfo();
            CIFXCHNINFO.MdiParent = this;
            CIFXCHNINFO.Dock = DockStyle.Fill;
            CIFXCHNINFO.Show();
        }

        private void busStateToolStripMenuItem_Click(object sender, EventArgs e)
        {
            cifXBusState CIFXBUSSTATE = new cifXBusState();
            CIFXBUSSTATE.MdiParent = this;
            CIFXBUSSTATE.Dock = DockStyle.Fill;
            CIFXBUSSTATE.Show();
        }

        private void configLockToolStripMenuItem_Click(object sender, EventArgs e)
        {
            cifXLockConfig CIFXCONFLOCK = new cifXLockConfig();
            CIFXCONFLOCK.MdiParent = this;
            CIFXCONFLOCK.Dock = DockStyle.Fill;
            CIFXCONFLOCK.Show();
        }

        private void watchdogToolStripMenuItem_Click(object sender, EventArgs e)
        {
            cifXWatchdog CIFXWATCHDOG = new cifXWatchdog();
            CIFXWATCHDOG.MdiParent = this;
            CIFXWATCHDOG.Dock = DockStyle.Fill;
            CIFXWATCHDOG.Show();
        }

        private void fileExplorerToolStripMenuItem_Click(object sender, EventArgs e)
        {
            cifXFileExplorer CIFXFILEEXP = new cifXFileExplorer();
            CIFXFILEEXP.MdiParent = this;
            CIFXFILEEXP.Dock = DockStyle.Fill;
            CIFXFILEEXP.Show();
        }

        private void iODataToolStripMenuItem_Click(object sender, EventArgs e)
        {
            cifXIOData CIFXIODATA = new cifXIOData();
            CIFXIODATA.MdiParent = this;
            CIFXIODATA.Dock = DockStyle.Fill;
            CIFXIODATA.Show();
        }

        private void pcketDataToolStripMenuItem_Click(object sender, EventArgs e)
        {
            cifXPacketData CIFXPCTDATA = new cifXPacketData();
            CIFXPCTDATA.MdiParent = this;
            CIFXPCTDATA.Dock = DockStyle.Fill;
            CIFXPCTDATA.Show();
        }

        private void mailboxStateToolStripMenuItem_Click(object sender, EventArgs e)
        {
            cifXMBXState CIFXMBXSTATE = new cifXMBXState();
            CIFXMBXSTATE.MdiParent = this;
            CIFXMBXSTATE.Dock = DockStyle.Fill;
            CIFXMBXSTATE.Show();
        }

        private void AppStart()
        {
            //Menu Device
            this.closeToolStripMenuItem.Enabled = false;
            this.resetToolStripMenuItem.Enabled = false;
            this.applicationReadyToolStripMenuItem.Enabled = false;
            this.busStateToolStripMenuItem.Enabled = false;
            this.configLockToolStripMenuItem.Enabled = false;
            this.watchdogToolStripMenuItem.Enabled = false;
            this.downloadToolStripMenuItem.Enabled = false;
            this.fileExplorerToolStripMenuItem.Enabled = false;

            //Menu Information
            this.channelInformationToolStripMenuItem.Enabled = false;
            this.mailboxStateToolStripMenuItem.Enabled = false;

            //Menu Datatransfer
            this.pcketDataToolStripMenuItem.Enabled = false;
            this.iODataToolStripMenuItem.Enabled = false;

        }

        public void SysDeviceOpened()
        {
            //Menu Device
            this.closeToolStripMenuItem.Enabled = true;
            this.resetToolStripMenuItem.Enabled = true;
            this.applicationReadyToolStripMenuItem.Enabled = false;
            this.busStateToolStripMenuItem.Enabled = false;
            this.configLockToolStripMenuItem.Enabled = false;
            this.watchdogToolStripMenuItem.Enabled = false;
            this.downloadToolStripMenuItem.Enabled = true;
            this.fileExplorerToolStripMenuItem.Enabled = true;

            //Menu Information
            this.channelInformationToolStripMenuItem.Enabled = true;
            this.mailboxStateToolStripMenuItem.Enabled = true;

            //Menu Datatransfer
            this.pcketDataToolStripMenuItem.Enabled = true;
            this.iODataToolStripMenuItem.Enabled = false;

        }

        public void ChannelOpened()
        {
            //Menu Device
            this.closeToolStripMenuItem.Enabled = true;
            this.resetToolStripMenuItem.Enabled = true;
            this.applicationReadyToolStripMenuItem.Enabled = true;
            this.busStateToolStripMenuItem.Enabled = true;
            this.configLockToolStripMenuItem.Enabled = true;
            this.watchdogToolStripMenuItem.Enabled = true;
            this.downloadToolStripMenuItem.Enabled = true;
            this.fileExplorerToolStripMenuItem.Enabled = true;

            //Menu Information
            this.channelInformationToolStripMenuItem.Enabled = true;
            this.mailboxStateToolStripMenuItem.Enabled = true;

            //Menu Datatransfer
            this.pcketDataToolStripMenuItem.Enabled = true;
            this.iODataToolStripMenuItem.Enabled = true;
        }

        private void OpenDriver()
        {
            UInt32 lret = 0;
            lret = cifXUser.xDriverOpen();
            if (lret == 0)
                this.statusStrip.Items[0].Text = "Driver was succesfully opened";
            else
                this.statusStrip.Items[0].Text = "Driver open failed with " + string.Format("0x{0:X8}", lret.ToString("x"));
        }
    }
}
